/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.EditableNumericSpinner;
import DE.siemens.ad.logo.dialog.comp.IntegerOrReferencePanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.RampControlParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.panel.AmplifierPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class RampControlPanel
extends AmplifierPanel {
    private EditableNumericSpinner fRate;
    private IntegerOrReferencePanel fRamp1;
    private IntegerOrReferencePanel fRamp2;
    private EditableNumericSpinner fMaxOutput;
    private EditableNumericSpinner fStartStopOffset;

    public RampControlPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.initComponents();
    }

    protected void initComponents() {
        super.initComponents();
        this.fMeasurementPanel.getSensorSelectionPanel().setVisible(false);
        JPanel rampPanel = new JPanel(new GridBagLayout());
        this.addParameterPanel(rampPanel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 5, 0);
        rampPanel.add((Component)new JSeparator(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(3, 4, 3, 0);
        rampPanel.add((Component)new JLabel(Language.getString("dialog.parameter.ramp.rate", "Rate")), gbc);
        JPanel ratePanel = new JPanel(new BorderLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(3, 6, 3, 3);
        rampPanel.add((Component)ratePanel, gbc);
        this.fRate = new EditableNumericSpinner();
        ratePanel.add(this.fRate);
        JLabel label = new JLabel("  " + Language.getString("dialog.parameter.ramp.rateUnit", "Steps/s"));
        ratePanel.add((Component)label, "East");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(3, 4, 3, 0);
        rampPanel.add((Component)new JLabel(Language.getString("dialog.parameter.ramp.maxAQ", "Max. Level")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(3, 6, 3, 3);
        this.fMaxOutput = new EditableNumericSpinner();
        rampPanel.add((Component)this.fMaxOutput, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(3, 4, 3, 0);
        rampPanel.add((Component)new JLabel(Language.getString("dialog.parameter.ramp.startStop", "Start/Stop offset")), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(3, 6, 3, 3);
        this.fStartStopOffset = new EditableNumericSpinner();
        JPanel startStopOffsetPanel = new JPanel(new BorderLayout());
        startStopOffsetPanel.add(this.fStartStopOffset);
        startStopOffsetPanel.add((Component)new JLabel("  (100" + Language.getString("dialog.parameter.message.menu.tickerTimeUnit", "ms") + ")"), "East");
        rampPanel.add((Component)startStopOffsetPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 2, 0, 2);
        this.fRamp1 = new IntegerOrReferencePanel();
        this.fRamp1.setTitle(Language.getString("dialog.parameter.ramp.ramp1", "Level 1"));
        rampPanel.add((Component)this.fRamp1, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 0, 2);
        this.fRamp2 = new IntegerOrReferencePanel();
        this.fRamp2.setTitle(Language.getString("dialog.parameter.ramp.ramp2", "Level 2"));
        rampPanel.add((Component)this.fRamp2, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 0, 5, 0);
        rampPanel.add((Component)new JSeparator(), gbc);
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        WiringDiagram wiringDiagram = ((BlockParameter)this.fParameterReference).getBlock().getWiringDiagram();
        Block notIncluded = ((BlockParameter)this.fParameterReference).getBlock();
        this.fRamp1.setReferenceList(wiringDiagram.getBlocksForReference(notIncluded, true));
        this.fRamp2.setReferenceList(wiringDiagram.getBlocksForReference(notIncluded, true));
        this.fRate.setProperties(((RampControlParameter)this.fParameterReference).getRate());
        this.fMaxOutput.setProperties(((RampControlParameter)this.fParameterReference).getMaxOutput());
        this.fStartStopOffset.setProperties(((RampControlParameter)this.fParameterReference).getStartStopOffset());
        this.fRamp1.setProperties(((RampControlParameter)this.fParameterReference).getRamp1());
        this.fRamp2.setProperties(((RampControlParameter)this.fParameterReference).getRamp2());
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        ((RampControlParameter)this.fParameterReference).setRate(this.fRate.getValueProperties());
        ((RampControlParameter)this.fParameterReference).setMaxOutput(this.fMaxOutput.getValueProperties());
        ((RampControlParameter)this.fParameterReference).setStartStopOffset(this.fStartStopOffset.getValueProperties());
        ((RampControlParameter)this.fParameterReference).setRamp1(this.fRamp1.getValue());
        ((RampControlParameter)this.fParameterReference).setRamp2(this.fRamp2.getValue());
    }

    public boolean checkChanged() {
        if (this.fRate.checkChanged()) {
            return true;
        }
        if (this.fMaxOutput.checkChanged()) {
            return true;
        }
        if (this.fStartStopOffset.checkChanged()) {
            return true;
        }
        if (this.fRamp1.checkChanged()) {
            return true;
        }
        if (this.fRamp2.checkChanged()) {
            return true;
        }
        return super.checkChanged();
    }

    public boolean checkFieldContents() {
        if (!this.fRate.checkValue(true)) {
            return false;
        }
        if (!this.fMaxOutput.checkValue(true)) {
            return false;
        }
        if (!this.fStartStopOffset.checkValue(true)) {
            return false;
        }
        if (!this.fRamp1.checkValue(true)) {
            return false;
        }
        if (!this.fRamp2.checkValue(true)) {
            return false;
        }
        return super.checkFieldContents();
    }
}

